/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
using System.Drawing;
using System.Drawing.Text;
using System.IO;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// FontData class needed to wrap and help loading of fonts as they are asyncrhone
    /// </summary>
    public class FontData
    {
        private int id;
        private Font font;
        private int revision;
        private FontFamily fontFamily;
        private string fileName;
        private PrivateFontCollection fontCollection;

        /// <summary>
        /// Gets or sets the Font Token ID        
        /// </summary>
        internal int Id
        {
            get { return id; }
            set { id = value; }
        }        

        /// <summary>
        /// Gets or sets the Revision (Depending and reloading of the side)
        /// </summary>
        internal int Revision
        {
            get { return revision; }
            set { revision = value; }
        }

        /// <summary>
        /// Gets or sets the Font itself        
        /// </summary>
        internal Font Font
        {
            get { return font; }
            set { font = value; }
        }

        /// <summary>
        /// Gets or sets the family of this font
        /// </summary>
        internal FontFamily FontFamily
        {
            get { return fontFamily; }
            set { fontFamily = value; }
        }

        /// <summary>
        /// Gets or sets the filename of this font if it is an embedded font
        /// </summary>
        internal string FileName
        {
            set { fileName = value; }
        }

        /// <summary>
        /// Gets or sets the filename of this font if it is an embedded font
        /// </summary>
        internal PrivateFontCollection FontCollection
        {
            set { fontCollection = value; }
        }

        /// <summary>
        /// Delete temporary file of embbeded fonts
        /// </summary>
        ~FontData()
        {
            if (fileName != null)
            {
                if (fontCollection != null)
                {
                    fontCollection.Dispose();
                    fontCollection = null;
                }
                try
                {
                    File.Delete(fileName);
                }
                catch (System.UnauthorizedAccessException)
                {
                    new FontData().fileName = fileName; // try it later again
                }
                fileName = null;
            }
        }
    }
}